<?php
// debug_login.php - sadece test için. Çalıştıktan sonra silin!
ini_set('display_errors',1);
error_reporting(E_ALL);

echo "<h3>DEBUG LOGIN</h3>";

session_start();

require_once __DIR__ . '/includes/db.php';
require_once __DIR__ . '/includes/functions.php';

// Show PHP version and session info
echo "<p><b>PHP versiyon:</b> " . phpversion() . "</p>";
echo "<p><b>Session id:</b> " . session_id() . "</p>";

// Show POST (if any)
echo "<h4>POST verileri</h4><pre>";
print_r($_POST);
echo "</pre>";

// Use example credentials to test (you can change these)
$testUser = $_POST['username'] ?? 'admin';
$testPass = $_POST['password'] ?? '123456';

echo "<p>Test user: <b>{$testUser}</b> / Test pass (gösteriliyor sadece debug amaçlı): <b>{$testPass}</b></p>";

// Fetch user from DB
$stmt = $pdo->prepare("SELECT id, username, password FROM users WHERE username = ? LIMIT 1");
$stmt->execute([$testUser]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

echo "<h4>DB user kaydı</h4><pre>";
var_dump($user);
echo "</pre>";

if (!$user) {
    echo "<p style='color:red;'>Kullanıcı veritabanında bulunamadı.</p>";
    exit;
}

// Show length and raw hash
$len = isset($user['password']) ? strlen($user['password']) : 0;
echo "<p><b>password LENGTH:</b> {$len}</p>";
echo "<p><b>password raw:</b> " . htmlspecialchars($user['password']) . "</p>";

// Test password_verify
$verify = password_verify($testPass, $user['password']);
echo "<p><b>password_verify('{$testPass}', db_hash) =></b> " . ($verify ? '<span style=\"color:green\">TRUE</span>' : '<span style=\"color:red\">FALSE</span>') . "</p>";

// If false, show crypt fallback attempt
if (!$verify) {
    echo "<p>Alternatif testler:</p><pre>";
    echo "md5('" . $testPass . "') = " . md5($testPass) . PHP_EOL;
    echo "sha1('" . $testPass . "') = " . sha1($testPass) . PHP_EOL;
    echo "</pre>";
}

// Test session write (simulate login)
if ($verify) {
    $_SESSION['user_id'] = $user['id'];
    echo "<p style='color:green;'>Session user_id set: " . $_SESSION['user_id'] . "</p>";
    echo "<p>Session now has:</p><pre>"; print_r($_SESSION); echo "</pre>";
} else {
    echo "<p style='color:red;'>password_verify başarısız — burada problem var.</p>";
}

echo "<hr><p>Debug bitti. Lütfen çıktıyı buraya kopyala.</p>";
?>
